<?php

include 'connection.php';

// Get data from POST request
$deviceName = isset($_POST['devicename']) ? $_POST['devicename'] : '';
$active = isset($_POST['active']) ? $_POST['active'] : '';

// Check if device name is provided
if (!empty($deviceName)) {
    // Check if active parameter is provided
    if (!empty($active)) {
        // Update active state based on provided value
        if ($active === 'active' || $active === 'inactive') {
            $sql = "UPDATE user SET active = :active WHERE devicename = :devicename";
            $stmt = $conn->prepare($sql);
            $stmt->bindParam(':active', $active);
            $stmt->bindParam(':devicename', $deviceName);

            if ($stmt->execute()) {
                echo "Active state updated successfully";
            } else {
                echo "Error updating active state: " . $stmt->errorInfo()[2];
            }
        } else {
            echo "Invalid value for active parameter";
        }
    } else {
        // If active parameter is not provided, set active state as "active" by default
        $sql = "UPDATE user SET active = 'active' WHERE devicename = :devicename";
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':devicename', $deviceName);

        if ($stmt->execute()) {
            echo "Active state saved successfully";
        } else {
            echo "Error saving active state: " . $stmt->errorInfo()[2];
        }
    }
} else {
    echo "Device name is required";
}
?>

